
<!DOCTYPE html>
<?php
    if($this->session->userdata('site_lang') && in_array($this->session->userdata('site_lang'),json_decode($this->system->rtl_supported_language,true))) {
        $dir = 'rtl';
    } else {
        $dir = 'ltr';
    }
?>
<html dir='<?php echo $dir; ?>'>
    <head>
        <?php $this->load->view($this->path_to_view_admin . 'header'); ?>
    </head>
    <body>
        <?php $this->load->view($this->path_to_view_admin . 'header_body'); ?>
        <div class="d-flex" id="wrapper">
            <?php $this->load->view($this->path_to_view_admin . 'sidebar'); ?>
            <div id="page-content-wrapper">
                <div class="container-fluid">
                    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                        <h1 class="h2"><?php echo $this->lang->line('text_admin');?></h1>
                        <?php if (isset($btn)) { ?>
                            <a class="btn btn-sm btn-outline-secondary" href="<?php echo base_url() . $this->path_to_view_admin; ?>admin/insert">
                                <i class="fa fa-plus"></i> <?php echo $btn; ?>
                            </a>
                        <?php } ?>
                    </div>
                    <?php if ($this->session->flashdata('notification')) { ?>
                        <div class="alert alert-success"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button><button class="close" data-close="alert"></button>
                            <span><?php echo $this->session->flashdata('notification'); ?></span>
                        </div>
                    <?php } ?>
                    <?php if ($this->session->flashdata('error')) { ?>
                        <div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button><button class="close" data-close="alert"></button>
                            <span><?php echo $this->session->flashdata('error'); ?></span>
                        </div>
                    <?php } ?>
                    <div class="row">
                        <div class="col-md-12">
                                <form name="frmadminlist" method="post" action="<?php echo base_url() . $this->path_to_view_admin ?>admin">
                                                <table class="table table-striped table-bordered" id="manage_tbl">
                                                    <thead>
                                                        <tr>
                                                            <th><?php echo $this->lang->line('text_sr_no'); ?></th>
                                                            <th> <?php echo $this->lang->line('text_name'); ?></th>
                                                            <th> <?php echo $this->lang->line('text_email'); ?></th>
                                                            <th> <?php echo $this->lang->line('text_date'); ?></th>
                                                            <th><?php echo $this->lang->line('text_actions'); ?></th>
                                                        </tr>   
                                                    </thead>
                                                    <tbody>

                                                    </tbody>
                                                    <tfoot>
                                                        <tr>
                                                            <th><?php echo $this->lang->line('text_sr_no'); ?></th>
                                                            <th> <?php echo $this->lang->line('text_name'); ?></th>
                                                            <th> <?php echo $this->lang->line('text_email'); ?></th>
                                                            <th> <?php echo $this->lang->line('text_date'); ?></th>
                                                            <th><?php echo $this->lang->line('text_actions'); ?></th>
                                                        </tr>   
                                                    </tfoot>
                                                </table>
                                                <input type="hidden" name="action" />
                                                <input type="hidden" name="adminid" />
                                                <input type="hidden" name="publish" /> 
                                            </form>                            
                        </div>
                    </div>
                </div>
                <?php $this->load->view($this->path_to_view_admin . 'footer_body'); ?>
            </div>
        </div>
        <?php $this->load->view($this->path_to_view_admin . 'footer'); ?>
    </body>
</html>